/* 
 * print-cpu-times.c 
 *
 * Виводить інформацію про спожитий процесорний час.
 * Ілюструє порядок застосування функції getrusage().
 *
 */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/resource.h>


int main(void)
{
        struct rusage ru;
        unsigned long i;

        /* Просто витрачає процесорний час. */
        for (i = 0; i < 1000000; i++);

        /* Отримує інформацію про спожиті ресурси. */
        if (getrusage(RUSAGE_SELF, &ru) != 0) {
                fprintf(stderr, "Error getting my resource usage: %s\n",
                                                        strerror(errno));
                exit(EXIT_FAILURE);
        }

        /* Виводить інформацію про спожитий процесорний час. */
        printf("CPU time: %ld.%06ld sec user, %ld.%06ld sec system\n",
                                ru.ru_utime.tv_sec, ru.ru_utime.tv_usec,
                                ru.ru_stime.tv_sec, ru.ru_stime.tv_usec);

        exit(EXIT_SUCCESS);
}
